/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.compatibility.minecraft.ExperienceRange;
import jeresources.compatibility.minecraft.MobCompat;
import jeresources.util.LootTableHelper;
import jeresources.util.MobHelper;
import jeresources.util.TranslationHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_52;

public class MobEntry {
    private static final List<String> ANY_BIOMES = List.of("jer.any");
    private final List<String> biomes;
    private final Supplier<class_1309> entitySupplier;
    @Nullable
    private class_1309 entity;
    @Nullable
    private LightLevel lightLevel;
    @Nullable
    private ExperienceRange experience;
    private List<LootDrop> drops;

    private static List<String> distinctBiomes(String ... biomes) {
        return Arrays.stream(biomes).distinct().toList();
    }

    private static List<LootDrop> distinctDrops(LootDrop ... drops) {
        return MobEntry.distinctDrops(Arrays.stream(drops));
    }

    private static List<LootDrop> distinctDrops(Stream<LootDrop> dropsStream) {
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        return dropsStream.filter(drop -> drop != null && drop.item != null && seen.add(drop.item.method_7909())).toList();
    }

    public static MobEntry create(Supplier<class_1309> entity, LightLevel lightLevel, int minExp, int maxExp, String[] biomes, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, new ExperienceRange(minExp, maxExp), MobEntry.distinctBiomes(biomes), MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<class_1309> entity, LightLevel lightLevel, String[] biomes, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, null, MobEntry.distinctBiomes(biomes), MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<class_1309> entity, LightLevel lightLevel, int exp, String[] biomes, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, new ExperienceRange(exp, exp), MobEntry.distinctBiomes(biomes), MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<class_1309> entity, LightLevel lightLevel, int exp, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, new ExperienceRange(exp, exp), ANY_BIOMES, MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<class_1309> entity, LightLevel lightLevel, int minExp, int maxExp, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, new ExperienceRange(minExp, maxExp), ANY_BIOMES, MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<class_1309> entity, LightLevel lightLevel, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, null, ANY_BIOMES, MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<class_1309> entity, LootDrop ... drops) {
        return new MobEntry(entity, null, null, ANY_BIOMES, MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<class_1309> entity, class_52 lootTable) {
        List<LootDrop> drops = LootTableHelper.toDrops(lootTable);
        return new MobEntry(entity, null, null, ANY_BIOMES, drops);
    }

    public static MobEntry create(Supplier<class_1309> entity) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        return new MobEntry(entity, null, null, ANY_BIOMES, drops);
    }

    private MobEntry(Supplier<class_1309> entitySupplier, @Nullable LightLevel lightLevel, @Nullable ExperienceRange experience, List<String> biomes, List<LootDrop> drops) {
        this.entitySupplier = entitySupplier;
        this.entity = null;
        this.lightLevel = lightLevel;
        this.biomes = biomes;
        this.drops = drops;
        this.experience = experience;
    }

    public class_1309 getEntity() {
        if (this.entity == null) {
            this.entity = this.entitySupplier.get();
        }
        return this.entity;
    }

    public String getMobName() {
        class_1309 entity = this.getEntity();
        return MobHelper.getExpandedName(entity);
    }

    public List<LootDrop> getDrops() {
        return this.drops;
    }

    public List<class_1799> getDropsItemStacks() {
        return this.drops.stream().map(LootDrop::getDrops).flatMap(Collection::stream).toList();
    }

    public boolean hasMultipleBiomes() {
        return this.biomes.size() > 1;
    }

    public Stream<String> getTranslatedBiomes() {
        return this.biomes.stream().map(x$0 -> TranslationHelper.translateAndFormat(x$0, new Object[0]));
    }

    public void setDrops(Collection<LootDrop> drops) {
        this.drops = MobEntry.distinctDrops(drops.stream());
    }

    public LightLevel getLightLevel() {
        if (this.lightLevel == null) {
            class_1309 entity = this.getEntity();
            this.lightLevel = MobCompat.getLightLevel((class_1297)entity);
        }
        return this.lightLevel;
    }

    public String getExp() {
        if (this.experience == null) {
            class_1309 entity = this.getEntity();
            this.experience = MobCompat.getExperience(entity);
        }
        return this.experience.getExpString();
    }
}

